# Troubleshooting Aplikasi Hosting
## Domain: persidangan.ellyas.my.id

## 🔍 **Masalah: Halaman Kosong Setelah Login**

### **Langkah 1: Debug dengan File debug.php**

1. Upload file `debug.php` ke hosting
2. Akses: `https://persidangan.ellyas.my.id/debug.php`
3. Periksa output untuk melihat:
   - PHP version
   - Database connection
   - File permissions
   - Missing files

### **Langkah 2: Periksa Error Log Hosting**

1. Login ke cPanel hosting
2. Buka "Error Logs" atau "Logs"
3. Cari error terkait aplikasi
4. Catat error message untuk troubleshooting

### **Langkah 3: Test Database Connection**

Jika debug.php menunjukkan database error:

1. **Periksa informasi database:**
   ```php
   $host = 'localhost'; // atau IP server database
   $username = 'your_db_username'; // Username database hosting
   $password = 'your_db_password'; // Password database hosting
   $database = 'your_db_name'; // Nama database hosting
   ```

2. **Update file `config/database.php`:**
   - Ganti dengan informasi database hosting yang benar
   - Pastikan database sudah dibuat
   - Pastikan user database memiliki permission

### **Langkah 4: Periksa File Structure**

Pastikan semua file terupload dengan benar:

```
public_html/
├── assets/
│   ├── images/
│   │   └── logo-gereja-toraja.png
│   └── css/
│       └── style.css
├── config/
│   ├── database.php (UPDATE DENGAN INFO HOSTING)
│   └── database_hosting.php
├── includes/
│   └── functions.php
├── uploads/
│   └── peserta/
├── .htaccess
├── index.php
├── dashboard.php
├── activity_logs.php
├── jemaat.php
├── peserta.php
├── upload.php
├── users.php
├── logout.php
├── view_pdf.php
├── view_video.php
├── 404.php
├── 500.php
├── debug.php
└── robots.txt
```

## 🛠️ **Solusi Langkah demi Langkah**

### **Solusi 1: Update Database Configuration**

1. **Edit file `config/database.php`:**
   ```php
   <?php
   // Konfigurasi Database untuk Hosting
   $host = 'localhost'; // Ganti jika berbeda
   $username = 'your_db_username'; // Username database hosting
   $password = 'your_db_password'; // Password database hosting
   $database = 'your_db_name'; // Nama database hosting
   
   // Membuat koneksi
   $conn = new mysqli($host, $username, $password, $database);
   
   // Cek koneksi
   if ($conn->connect_error) {
       die("Koneksi gagal: " . $conn->connect_error);
   }
   
   // Set charset ke UTF-8
   $conn->set_charset("utf8");
   ?>
   ```

2. **Buat database dan tabel:**
   - Login ke phpMyAdmin hosting
   - Buat database baru
   - Import struktur tabel dari `config/database_hosting.php`

### **Solusi 2: Set File Permissions**

1. **Set permission folder:**
   ```bash
   uploads/ = 755
   uploads/peserta/ = 755
   config/ = 644
   includes/ = 644
   ```

2. **Set permission file:**
   ```bash
   .htaccess = 644
   *.php = 644
   ```

### **Solusi 3: Test dengan File Sederhana**

1. **Buat file test sederhana:**
   ```php
   <?php
   echo "PHP berfungsi!";
   phpinfo();
   ?>
   ```

2. **Upload dan akses untuk memastikan PHP berjalan**

### **Solusi 4: Periksa .htaccess**

1. **Sementara disable .htaccess:**
   - Rename `.htaccess` menjadi `.htaccess.bak`
   - Test aplikasi
   - Jika berfungsi, masalah ada di .htaccess

2. **Update .htaccess untuk hosting:**
   ```apache
   # Basic .htaccess untuk hosting
   RewriteEngine On
   
   # Protect sensitive files
   <Files "config/*.php">
       Require all denied
   </Files>
   
   # Prevent directory listing
   Options -Indexes
   ```

## 🔧 **Masalah Umum dan Solusi**

### **1. Database Connection Error**
```
Error: Access denied for user 'username'@'localhost'
```
**Solusi:**
- Periksa username dan password database
- Pastikan user database memiliki permission
- Cek apakah database sudah dibuat

### **2. File Not Found Error**
```
Error: File config/database.php tidak ditemukan
```
**Solusi:**
- Pastikan semua file terupload
- Periksa struktur folder
- Cek permission file

### **3. Permission Denied Error**
```
Error: Permission denied
```
**Solusi:**
- Set permission folder uploads = 755
- Set permission file = 644
- Cek ownership file

### **4. Session Error**
```
Error: Session cannot be started
```
**Solusi:**
- Pastikan session.save_path writable
- Cek PHP session configuration
- Restart web server jika perlu

### **5. Memory Limit Error**
```
Error: Allowed memory size exhausted
```
**Solusi:**
- Update .htaccess dengan memory_limit
- Kontak hosting provider untuk increase limit

## 📋 **Checklist Troubleshooting**

- [ ] Upload file `debug.php` dan akses
- [ ] Periksa error log hosting
- [ ] Update database configuration
- [ ] Set file permissions
- [ ] Test database connection
- [ ] Periksa file structure
- [ ] Test dengan file sederhana
- [ ] Disable .htaccess sementara
- [ ] Kontak hosting provider jika perlu

## 🚀 **Langkah Setelah Fix**

1. **Test login:**
   - Username: `admin`
   - Password: `admin123`

2. **Test semua fitur:**
   - Upload dokumen
   - Tambah data jemaat
   - Tambah data peserta
   - Log aktivitas

3. **Monitor error log:**
   - Cek error log secara berkala
   - Monitor performa aplikasi

## 📞 **Kontak Support**

Jika masalah masih berlanjut:

1. **Siapkan informasi:**
   - Error message lengkap
   - Output dari debug.php
   - Screenshot error
   - Hosting provider

2. **Dokumentasikan:**
   - Langkah yang sudah dicoba
   - Hasil setiap langkah
   - Waktu kejadian error

3. **Kontak:**
   - Hosting provider support
   - Developer/administrator
   - Forum komunitas

## ✅ **Indikator Berhasil**

- ✅ Halaman login tampil normal
- ✅ Login berhasil tanpa error
- ✅ Dashboard tampil dengan data
- ✅ Semua menu berfungsi
- ✅ Upload file berhasil
- ✅ Database connection stabil
- ✅ Tidak ada error di log 