# Sistem Log Aktivitas - Sistem Persidangan

## Deskripsi
Sistem log aktivitas telah berhasil diimplementasikan untuk merekam semua aktivitas pengguna dalam sistem persidangan. Sistem ini dapat mencatat aktivitas seperti login, logout, create, update, delete, upload, download, import, dan export data.

## Fitur yang Tersedia

### 1. Tabel Log Aktivitas
- **Tabel**: `activity_logs`
- **Struktur**:
  - `id`: Primary key
  - `user_id`: ID pengguna yang melakukan aktivitas
  - `username`: Username pengguna
  - `full_name`: Nama lengkap pengguna
  - `action`: Jenis aktivitas (CREATE, UPDATE, DELETE, LOGIN, LOGOUT, UPLOAD, DOWNLOAD, IMPORT, EXPORT)
  - `table_name`: Nama tabel yang terpengaruh
  - `record_id`: ID record yang terpengaruh
  - `description`: Deskripsi aktivitas
  - `ip_address`: Alamat IP pengguna
  - `user_agent`: User agent browser
  - `created_at`: Waktu aktivitas

### 2. Fungsi Log Aktivitas
Berikut adalah fungsi-fungsi yang telah ditambahkan di `includes/functions.php`:

#### `logActivity($conn, $action, $table_name, $record_id, $description)`
- Mencatat aktivitas umum (CREATE, UPDATE, DELETE, UPLOAD, dll)
- Parameter:
  - `$conn`: Koneksi database
  - `$action`: Jenis aktivitas
  - `$table_name`: Nama tabel (opsional)
  - `$record_id`: ID record (opsional)
  - `$description`: Deskripsi aktivitas (opsional)

#### `logLogin($conn, $user_id, $username, $full_name)`
- Mencatat aktivitas login pengguna

#### `logLogout($conn)`
- Mencatat aktivitas logout pengguna

#### `getActivityLogs($conn, $limit, $offset, $user_id, $action, $table_name, $date_from, $date_to)`
- Mengambil data log aktivitas dengan filter dan pagination

#### `getActivityStats($conn, $user_id, $date_from, $date_to)`
- Mengambil statistik aktivitas

#### `getTotalLogs($conn, $user_id, $action, $table_name, $date_from, $date_to)`
- Menghitung total log aktivitas

#### `formatActivityTime($timestamp)`
- Format waktu yang user-friendly (contoh: "2 jam yang lalu")

#### `getActionBadgeColor($action)`
- Mendapatkan warna badge berdasarkan jenis aktivitas

#### `getActionIcon($action)`
- Mendapatkan icon berdasarkan jenis aktivitas

### 3. Halaman Log Aktivitas
- **File**: `activity_logs.php`
- **Fitur**:
  - Tampilan log aktivitas dengan pagination
  - Filter berdasarkan user, aksi, tabel, dan tanggal
  - Statistik aktivitas
  - Export ke CSV
  - Tampilan yang user-friendly dengan badge dan icon

### 4. Export Log Aktivitas
- **File**: `export_logs.php`
- **Fitur**: Export log aktivitas ke format CSV dengan filter yang sama

## Aktivitas yang Dicatat

### 1. Login/Logout
- **Login**: Dicatat saat user berhasil login
- **Logout**: Dicatat saat user logout

### 2. Operasi CRUD Jemaat
- **CREATE**: Saat menambah data jemaat baru
- **UPDATE**: Saat mengupdate data jemaat
- **DELETE**: Saat menghapus data jemaat

### 3. Operasi CRUD Peserta
- **CREATE**: Saat menambah data peserta baru
- **UPDATE**: Saat mengupdate data peserta
- **DELETE**: Saat menghapus data peserta
- **IMPORT**: Saat mengimport data peserta dari file

### 4. Operasi CRUD User
- **CREATE**: Saat menambah user baru
- **UPDATE**: Saat mengupdate data user
- **DELETE**: Saat menghapus user

### 5. Upload Dokumen
- **UPLOAD**: Saat mengupload dokumen baru

## Implementasi di File

### 1. Database (`config/database.php`)
- Menambahkan tabel `activity_logs`

### 2. Functions (`includes/functions.php`)
- Menambahkan semua fungsi log aktivitas

### 3. Login (`index.php`)
- Menambahkan log saat login berhasil

### 4. Logout (`logout.php`)
- Menambahkan log saat logout

### 5. Jemaat (`jemaat.php`)
- Menambahkan log untuk operasi CREATE, UPDATE, DELETE

### 6. Peserta (`peserta.php`)
- Menambahkan log untuk operasi CREATE, UPDATE, DELETE, IMPORT

### 7. Users (`users.php`)
- Menambahkan log untuk operasi CREATE, UPDATE, DELETE

### 8. Upload (`upload.php`)
- Menambahkan log untuk operasi UPLOAD

### 9. Navigation
- Menambahkan link "Log Aktivitas" di semua halaman untuk admin dan panitia

## Cara Menggunakan

### 1. Akses Log Aktivitas
1. Login sebagai admin atau panitia
2. Klik menu "Log Aktivitas" di navigation bar
3. Halaman akan menampilkan semua log aktivitas

### 2. Filter Log
1. Gunakan form filter di bagian atas halaman
2. Pilih user, aksi, tabel, atau rentang tanggal
3. Klik tombol "Filter" untuk menerapkan filter
4. Klik tombol "Reset" untuk menghapus filter

### 3. Export Log
1. Setelah menerapkan filter (opsional)
2. Klik tombol "Export" di bagian atas halaman
3. File CSV akan otomatis terdownload

### 4. Melihat Statistik
- Statistik aktivitas akan ditampilkan di bagian atas halaman
- Menunjukkan jumlah aktivitas berdasarkan jenis aksi

## Keamanan

### 1. Akses Terbatas
- Hanya admin dan panitia yang dapat mengakses log aktivitas
- User dengan role "peserta" tidak dapat mengakses halaman log

### 2. Data yang Dicatat
- IP Address pengguna
- User Agent browser
- Waktu aktivitas yang presisi
- Deskripsi aktivitas yang detail

### 3. Validasi Input
- Semua input difilter dan divalidasi
- Menggunakan prepared statements untuk mencegah SQL injection

## Manfaat

### 1. Audit Trail
- Mencatat semua aktivitas pengguna
- Dapat melacak siapa melakukan apa dan kapan
- Berguna untuk keamanan dan troubleshooting

### 2. Monitoring
- Dapat memantau aktivitas sistem secara real-time
- Mengidentifikasi pola penggunaan
- Deteksi aktivitas mencurigakan

### 3. Pelaporan
- Data dapat diexport untuk keperluan pelaporan
- Statistik aktivitas untuk analisis
- Dokumentasi aktivitas sistem

## Catatan Teknis

### 1. Performa
- Log aktivitas menggunakan indeks pada kolom `created_at` dan `user_id`
- Pagination untuk menangani data yang besar
- Filter yang efisien

### 2. Storage
- Log aktivitas disimpan secara permanen
- Perlu monitoring ukuran tabel untuk performa optimal
- Dapat diimplementasikan sistem cleanup otomatis

### 3. Backup
- Log aktivitas termasuk dalam backup database
- Data penting untuk audit trail

## Kesimpulan

Sistem log aktivitas telah berhasil diimplementasikan dengan fitur yang lengkap dan user-friendly. Sistem ini memberikan kemampuan untuk melacak semua aktivitas pengguna dalam sistem persidangan, yang sangat berguna untuk keamanan, monitoring, dan pelaporan. 