# Sistem Manajemen Dokumen Persidangan

Aplikasi web untuk menyimpan dan mengelola dokumen PDF, gambar, dan video dengan sistem role user yang berbeda. PDF ditampilkan sebagai flipping book, gambar dalam gallery, dan video dalam showcase.

## Fitur Utama

### 🎯 Sistem Role User
- **Administrator**: Akses penuh ke semua fitur termasuk manajemen user
- **Panitia**: Dapat upload dan mengelola dokumen
- **Peserta**: Hanya dapat melihat dokumen

### 📄 Manajemen Dokumen
- **PDF**: Ditampilkan sebagai flipping book dengan navigasi halaman
- **Gambar**: Ditampilkan dalam gallery dengan lightbox
- **Video**: Ditampilkan dalam showcase dengan player modern
- **Multiple Upload**: Upload beberapa file gambar atau video sekaligus

### 🔐 Keamanan
- Sistem login dengan password hashing
- Validasi file upload
- Pembatasan akses berdasarkan role

## Teknologi yang Digunakan

- **Backend**: PHP 7.4+
- **Database**: MySQL 5.7+
- **Frontend**: HTML5, CSS3, JavaScript
- **Framework**: Bootstrap 5.3.0
- **Libraries**:
  - PDF.js untuk PDF viewer
  - Plyr untuk video player
  - Lightbox2 untuk image gallery
  - Font Awesome untuk icons

## Instalasi

### Prerequisites
- XAMPP/WAMP/LAMP server
- PHP 7.4 atau lebih tinggi
- MySQL 5.7 atau lebih tinggi
- Web browser modern

### Langkah Instalasi

1. **Clone atau download project**
   ```bash
   git clone [repository-url]
   cd persidangan
   ```

2. **Setup Database**
   - Buka phpMyAdmin atau MySQL client
   - Buat database baru (opsional, akan dibuat otomatis)
   - Import file `database.sql` jika ada

3. **Konfigurasi Database**
   - Edit file `config/database.php`
   - Sesuaikan host, username, password, dan nama database

4. **Setup Web Server**
   - Copy folder project ke direktori web server (htdocs untuk XAMPP)
   - Pastikan folder `uploads/` memiliki permission write

5. **Akses Aplikasi**
   - Buka browser dan akses `http://localhost/persidangan`
   - Login dengan akun default:
     - **Admin**: username: `admin`, password: `admin123`
     - **Panitia**: username: `panitia`, password: `panitia123`
     
     - **Peserta**: username: `peserta`, password: `peserta123`

## Struktur File

```
persidangan/
├── index.php              # Halaman login
├── dashboard.php          # Dashboard utama
├── upload.php             # Halaman upload dokumen
├── view_pdf.php          # PDF viewer dengan flipping book
├── view_video.php        # Video player showcase
├── jemaat.php            # Manajemen data jemaat
├── peserta.php           # Manajemen data peserta
├── users.php             # Manajemen user (admin only)
├── logout.php            # Logout
├── config/
│   └── database.php      # Konfigurasi database
├── includes/
│   └── functions.php     # Fungsi-fungsi helper
├── assets/
│   └── css/
│       └── style.css     # Custom CSS
├── uploads/              # Folder penyimpanan file
│   ├── peserta/          # Folder foto peserta
│   └── .htaccess         # Keamanan folder uploads
└── README.md             # Dokumentasi
```

## Fitur Detail

### 📖 PDF Flipping Book
- Navigasi halaman dengan tombol atau keyboard
- Zoom in/out
- Fullscreen mode
- Keyboard shortcuts (arrow keys, +/- untuk zoom)

### 🖼️ Image Gallery
- Lightbox untuk preview gambar
- Thumbnail preview
- Responsive design
- Download option

### 🎬 Video Showcase
- Modern video player dengan Plyr
- Keyboard shortcuts
- Related videos sidebar
- Fullscreen support
- Download option

### 📤 Multiple Upload System
- **Single Upload**: Upload satu file PDF, gambar, atau video
- **Multiple Images**: Upload hingga 10 file gambar sekaligus
- **Multiple Videos**: Upload hingga 5 file video sekaligus
- Preview file sebelum upload
- Validasi tipe dan ukuran file
- Progress tracking untuk setiap file

### 👥 User Management
- CRUD operations untuk user
- Role-based access control (Administrator, Panitia, Peserta)
- Password hashing
- Session management


### 🏛️ Data Jemaat Management
- CRUD operations untuk data jemaat
- Informasi lengkap jemaat (nama, alamat, pendeta, dll)
- Relasi dengan data peserta
- Validasi data

### 👤 Data Peserta Management
- CRUD operations untuk data peserta
- Upload foto peserta
- Relasi dengan jemaat
- Filter berdasarkan jemaat

- Validasi data lengkap

## Tipe File yang Didukung

### PDF
- Format: `.pdf`
- Maksimal: 100MB
- Fitur: Flipping book viewer

### Gambar
- Format: `.jpg`, `.jpeg`, `.png`, `.gif`
- Maksimal: 100MB
- Fitur: Gallery dengan lightbox

### Video
- Format: `.mp4`, `.avi`, `.mov`, `.wmv`
- Maksimal: 100MB
- Fitur: Video player showcase

## Keamanan

### File Upload Security
- Validasi tipe file
- Pembatasan ukuran file
- Nama file unik untuk mencegah konflik
- Sanitasi nama file

### Authentication & Authorization
- Password hashing dengan `password_hash()`
- Session management
- Role-based access control
- SQL injection prevention dengan prepared statements

### Data Protection
- Input sanitization
- XSS prevention
- CSRF protection (basic)

## Penggunaan

### Administrator
1. Login dengan akun admin
2. Kelola user melalui menu "Kelola User"
3. Upload dokumen seperti panitia
4. Akses semua fitur sistem

### Panitia
1. Login dengan akun panitia
2. Upload dokumen melalui menu "Upload Dokumen"
3. Pilih tipe upload: Single, Multiple Images, atau Multiple Videos
4. Upload beberapa file sekaligus untuk gambar atau video
5. Lihat dan kelola dokumen yang diupload
6. Tidak dapat mengakses manajemen user



### Peserta
1. Login dengan akun peserta
2. Lihat semua dokumen di dashboard
3. Buka PDF, gambar, dan video
4. Tidak dapat upload atau mengelola dokumen

## Troubleshooting

### Masalah Umum

**1. File tidak bisa diupload**
- Cek permission folder `uploads/`
- Pastikan ukuran file tidak melebihi 100MB
- Cek tipe file yang diupload

**2. Database connection error**
- Pastikan MySQL service berjalan
- Cek konfigurasi di `config/database.php`
- Pastikan database sudah dibuat

**3. PDF tidak tampil**
- Pastikan browser mendukung PDF.js
- Cek file PDF tidak corrupt
- Cek permission file di folder uploads

**4. Video tidak bisa diputar**
- Pastikan format video didukung
- Cek browser mendukung HTML5 video
- Pastikan file video tidak corrupt

### Log Error
- Cek error log PHP di folder server
- Cek error log MySQL
- Aktifkan error reporting untuk debugging

## Customization

### Mengubah Tema
- Edit file `assets/css/style.css`
- Sesuaikan warna dan style sesuai kebutuhan

### Menambah Tipe File
- Edit fungsi `isAllowedFileType()` di `includes/functions.php`
- Tambahkan ekstensi file yang diizinkan

### Mengubah Ukuran Upload
- Edit nilai `100 * 1024 * 1024` di `upload.php`
- Sesuaikan dengan kebutuhan server

## Contributing

1. Fork repository
2. Buat branch fitur baru
3. Commit perubahan
4. Push ke branch
5. Buat Pull Request

## License

Project ini menggunakan license MIT. Lihat file LICENSE untuk detail lebih lanjut.

## Support

Untuk bantuan dan pertanyaan:
- Buat issue di repository
- Hubungi developer melalui email
- Dokumentasi lengkap tersedia di README ini

## Changelog

### v1.0.0
- Initial release
- Sistem role user
- PDF flipping book
- Image gallery
- Video showcase
- User management
- Security features 