# Panduan Deployment ke Hosting
## Domain: persidangan.ellyas.my.id

## 📋 Persiapan Sebelum Upload

### 1. **Persiapan File**
- Pastikan semua file aplikasi sudah siap
- Logo PNG sudah ada di `assets/images/logo-gereja-toraja.png`
- File `.htaccess` sudah dikonfigurasi
- Halaman error 404.php dan 500.php sudah dibuat

### 2. **Database Hosting**
- Buat database baru di hosting
- Catat informasi database:
  - Host: (biasanya 'localhost')
  - Username: (username database hosting)
  - Password: (password database hosting)
  - Database name: (nama database yang dibuat)

## 🚀 Langkah-langkah Deployment

### 1. **Upload File ke Hosting**
1. Login ke cPanel hosting
2. Buka File Manager
3. Navigasi ke folder `public_html` atau `www`
4. Upload semua file aplikasi ke folder tersebut
5. Pastikan struktur folder tetap sama

### 2. **Konfigurasi Database**
1. Edit file `config/database_hosting.php`
2. Ganti informasi database:
```php
$host = 'localhost'; // atau IP server database
$username = 'your_db_username'; // Username database hosting
$password = 'your_db_password'; // Password database hosting
$database = 'your_db_name'; // Nama database hosting
```

### 3. **Update File Konfigurasi**
1. Rename `config/database_hosting.php` menjadi `config/database.php`
2. Atau update semua file untuk menggunakan `database_hosting.php`

### 4. **Set Permission Folder**
1. Set permission folder `uploads/` menjadi 755
2. Set permission folder `uploads/peserta/` menjadi 755
3. Pastikan folder dapat ditulis untuk upload file

### 5. **Test Aplikasi**
1. Akses domain: `https://persidangan.ellyas.my.id`
2. Test login dengan akun default:
   - Username: `admin`
   - Password: `admin123`
3. Test semua fitur aplikasi

## 🔧 Konfigurasi Tambahan

### 1. **SSL Certificate**
- Aktifkan SSL di hosting
- Uncomment baris HTTPS di `.htaccess`:
```apache
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

### 2. **Email Configuration**
- Konfigurasi email untuk notifikasi (opsional)
- Update SMTP settings jika diperlukan

### 3. **Backup Strategy**
- Setup backup otomatis database
- Backup file upload secara berkala
- Simpan backup di lokasi yang aman

## 📁 Struktur File di Hosting

```
public_html/
├── assets/
│   ├── images/
│   │   └── logo-gereja-toraja.png
│   └── css/
│       └── style.css
├── config/
│   ├── database.php (update dengan info hosting)
│   └── database_hosting.php
├── includes/
│   └── functions.php
├── uploads/
│   └── peserta/
├── .htaccess
├── index.php
├── dashboard.php
├── activity_logs.php
├── jemaat.php
├── peserta.php
├── upload.php
├── users.php
├── 404.php
├── 500.php
└── DEPLOYMENT_HOSTING.md
```

## 🔒 Keamanan

### 1. **File yang Dilindungi**
- `config/` folder tidak dapat diakses langsung
- `.htaccess` file dilindungi
- File `.sql` dan `.log` diblokir

### 2. **Security Headers**
- X-Frame-Options: DENY
- X-Content-Type-Options: nosniff
- X-XSS-Protection: enabled
- Referrer-Policy: strict-origin-when-cross-origin

### 3. **Upload Security**
- Validasi tipe file
- Batasan ukuran file (100MB)
- Sanitasi nama file

## 📊 Monitoring

### 1. **Log Monitoring**
- Monitor error logs hosting
- Cek activity logs aplikasi
- Monitor performa database

### 2. **Backup Monitoring**
- Pastikan backup berjalan otomatis
- Test restore backup secara berkala
- Monitor penggunaan storage

## 🆘 Troubleshooting

### 1. **Database Connection Error**
- Cek informasi database di `config/database.php`
- Pastikan database sudah dibuat
- Cek permission database user

### 2. **Upload File Error**
- Cek permission folder `uploads/`
- Pastikan `upload_max_filesize` dan `post_max_size` cukup
- Cek disk space hosting

### 3. **404 Error**
- Pastikan `.htaccess` sudah terupload
- Cek konfigurasi mod_rewrite di hosting
- Pastikan file ada di lokasi yang benar

### 4. **500 Error**
- Cek error log hosting
- Pastikan PHP version kompatibel (7.4+)
- Cek syntax error di file PHP

## 📞 Support

Jika mengalami masalah:
1. Cek error log hosting
2. Test di local environment
3. Hubungi support hosting
4. Dokumentasikan error untuk troubleshooting

## ✅ Checklist Deployment

- [ ] File aplikasi terupload ke hosting
- [ ] Database dibuat dan dikonfigurasi
- [ ] File `config/database.php` diupdate
- [ ] Permission folder diatur
- [ ] SSL certificate aktif (jika tersedia)
- [ ] Aplikasi dapat diakses via domain
- [ ] Login berfungsi normal
- [ ] Upload file berfungsi
- [ ] Semua fitur aplikasi teruji
- [ ] Backup strategy diatur
- [ ] Monitoring diaktifkan

## 🎯 Hasil Akhir

Setelah deployment berhasil, aplikasi akan dapat diakses di:
**https://persidangan.ellyas.my.id**

Dengan fitur lengkap:
- ✅ Login system
- ✅ Manajemen dokumen
- ✅ Data jemaat dan peserta
- ✅ Log aktivitas
- ✅ Upload file
- ✅ Export data
- ✅ Responsive design 