<?php
session_start();
require_once 'config/database.php';
require_once 'includes/functions.php';

// Cek apakah user sudah login
if (!isLoggedIn()) {
    header('Location: index.php');
    exit();
}

// Cek apakah user memiliki akses (admin atau panitia)
if (!hasRole('administrator') && !hasRole('panitia')) {
    header('Location: dashboard.php');
    exit();
}

// Filter
$filter_user_id = isset($_GET['user_id']) ? (int)$_GET['user_id'] : null;
$filter_action = isset($_GET['action']) ? $_GET['action'] : null;
$filter_table = isset($_GET['table_name']) ? $_GET['table_name'] : null;
$filter_date_from = isset($_GET['date_from']) ? $_GET['date_from'] : null;
$filter_date_to = isset($_GET['date_to']) ? $_GET['date_to'] : null;

// Ambil semua data log aktivitas (tanpa limit untuk export)
$logs = getActivityLogs($conn, 10000, 0, $filter_user_id, $filter_action, $filter_table, $filter_date_from, $filter_date_to);

// Set header untuk download CSV
$filename = 'activity_logs_' . date('Y-m-d_H-i-s') . '.csv';
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

// Buat file pointer untuk output
$output = fopen('php://output', 'w');

// Tambahkan BOM untuk UTF-8
fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));

// Header CSV
fputcsv($output, [
    'ID',
    'Waktu',
    'User ID',
    'Username',
    'Nama Lengkap',
    'Role',
    'Aksi',
    'Tabel',
    'Record ID',
    'Deskripsi',
    'IP Address',
    'User Agent'
]);

// Data log
while ($log = $logs->fetch_assoc()) {
    fputcsv($output, [
        $log['id'],
        $log['created_at'],
        $log['user_id'],
        $log['username'],
        $log['full_name'],
        $log['role'],
        $log['action'],
        $log['table_name'] ?? '',
        $log['record_id'] ?? '',
        $log['description'] ?? '',
        $log['ip_address'],
        $log['user_agent']
    ]);
}

fclose($output);
exit();
?> 