<?php
// File debug khusus untuk test database connection
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Database Connection Test</h2>";

// Test koneksi database dengan berbagai kemungkinan
$possible_hosts = ['localhost', '127.0.0.1'];
$possible_databases = ['ellyasmy_persidangan', 'persidangan', 'ellyasmy_klasis'];
$possible_usernames = ['ellyasmy_persidangan', 'ellyasmy', 'ellyasmy_klasis'];

echo "<h3>Testing Database Connections:</h3>";

foreach ($possible_hosts as $host) {
    foreach ($possible_databases as $database) {
        foreach ($possible_usernames as $username) {
            echo "<h4>Testing: $username@$host/$database</h4>";
            
            try {
                // Coba tanpa password dulu
                $conn = new mysqli($host, $username, '', $database);
                if (!$conn->connect_error) {
                    echo "<span style='color: green;'>✅ SUCCESS: $username@$host/$database (no password)</span><br>";
                    echo "MySQL Version: " . $conn->server_info . "<br>";
                    
                    // Test query
                    $result = $conn->query("SHOW TABLES");
                    if ($result) {
                        echo "Tables found: " . $result->num_rows . "<br>";
                        while ($row = $result->fetch_array()) {
                            echo "- " . $row[0] . "<br>";
                        }
                    }
                    $conn->close();
                    break 3; // Keluar dari semua loop jika berhasil
                } else {
                    echo "<span style='color: orange;'>⚠️ Failed (no password): " . $conn->connect_error . "</span><br>";
                }
            } catch (Exception $e) {
                echo "<span style='color: red;'>❌ Exception: " . $e->getMessage() . "</span><br>";
            }
        }
    }
}

echo "<hr>";
echo "<h3>PHP Info:</h3>";
echo "PHP Version: " . phpversion() . "<br>";
echo "MySQL Extension: " . (extension_loaded('mysqli') ? '✅ Loaded' : '❌ Not Loaded') . "<br>";

echo "<hr>";
echo "<h3>File Structure Check:</h3>";
$files_to_check = [
    'config/database.php',
    'config/database_hosting.php',
    'includes/functions.php',
    '.htaccess'
];

foreach ($files_to_check as $file) {
    if (file_exists($file)) {
        echo "✅ $file exists<br>";
    } else {
        echo "❌ $file missing<br>";
    }
}

echo "<hr>";
echo "<h3>Current Directory:</h3>";
echo getcwd() . "<br>";

echo "<hr>";
echo "<h3>Instructions:</h3>";
echo "<ol>";
echo "<li>Login ke cPanel hosting</li>";
echo "<li>Buka phpMyAdmin</li>";
echo "<li>Buat database baru</li>";
echo "<li>Buat user database dengan permission penuh</li>";
echo "<li>Update file config/database.php dengan info yang benar</li>";
echo "<li>Test lagi dengan file ini</li>";
echo "</ol>";
?> 