<?php
// File debugging untuk hosting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Debug Information</h2>";

// Test PHP
echo "<h3>PHP Version:</h3>";
echo "PHP Version: " . phpversion() . "<br>";

// Test MySQL
echo "<h3>MySQL Test:</h3>";
try {
    $host = 'localhost';
    $username = 'ellyasmy_klasis'; // Ganti dengan username database hosting
    $password = 'jbjkgUTRYU6%'; // Ganti dengan password database hosting
    $database = 'ellyasmy_klasis'; // Ganti dengan nama database hosting
    
    $conn = new mysqli($host, $username, $password, $database);
    
    if ($conn->connect_error) {
        echo "Database connection failed: " . $conn->connect_error . "<br>";
    } else {
        echo "Database connection successful!<br>";
        echo "MySQL Version: " . $conn->server_info . "<br>";
        
        // Test query
        $result = $conn->query("SHOW TABLES");
        if ($result) {
            echo "Tables found: " . $result->num_rows . "<br>";
            while ($row = $result->fetch_array()) {
                echo "- " . $row[0] . "<br>";
            }
        }
    }
} catch (Exception $e) {
    echo "Exception: " . $e->getMessage() . "<br>";
}

// Test file permissions
echo "<h3>File Permissions:</h3>";
$upload_dir = 'uploads/';
if (is_dir($upload_dir)) {
    echo "Uploads directory exists<br>";
    if (is_writable($upload_dir)) {
        echo "Uploads directory is writable<br>";
    } else {
        echo "Uploads directory is NOT writable<br>";
    }
} else {
    echo "Uploads directory does NOT exist<br>";
}

// Test session
echo "<h3>Session Test:</h3>";
session_start();
echo "Session ID: " . session_id() . "<br>";
echo "Session status: " . session_status() . "<br>";

// Test includes
echo "<h3>Include Test:</h3>";
if (file_exists('config/database.php')) {
    echo "database.php exists<br>";
} else {
    echo "database.php does NOT exist<br>";
}

if (file_exists('includes/functions.php')) {
    echo "functions.php exists<br>";
} else {
    echo "functions.php does NOT exist<br>";
}

// Test .htaccess
echo "<h3>.htaccess Test:</h3>";
if (file_exists('.htaccess')) {
    echo ".htaccess exists<br>";
} else {
    echo ".htaccess does NOT exist<br>";
}

// Show current directory
echo "<h3>Current Directory:</h3>";
echo getcwd() . "<br>";

// Show all files in current directory
echo "<h3>Files in current directory:</h3>";
$files = scandir('.');
foreach ($files as $file) {
    if ($file != '.' && $file != '..') {
        echo "- " . $file . "<br>";
    }
}
?> 