<?php
$host = 'persidangan.ellyas.my.id'; // Biasanya 'localhost' atau IP server database
$username = 'ellyasmy_klasis'; // Username database hosting
$password = 'jbjkgUTRYU6%'; // Password database hosting
$database = 'ellyasmy_klasis'; // Nama database hosting

// Membuat koneksi
$conn = new mysqli($host, $username, $password);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Buat database jika belum ada
$sql = "CREATE DATABASE IF NOT EXISTS $database";
if ($conn->query($sql) === TRUE) {
    $conn->select_db($database);
} else {
    die("Error membuat database: " . $conn->error);
}

// Buat tabel users
$sql = "CREATE TABLE IF NOT EXISTS users (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    email VARCHAR(100),
    role ENUM('administrator', 'panitia', 'peserta') NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
)";

if (!$conn->query($sql)) {
    die("Error membuat tabel users: " . $conn->error);
}



// Buat tabel documents
$sql = "CREATE TABLE IF NOT EXISTS documents (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    filename VARCHAR(255) NOT NULL,
    original_filename VARCHAR(255) NOT NULL,
    file_type ENUM('pdf', 'image', 'video') NOT NULL,
    file_size INT(11) NOT NULL,
    uploaded_by INT(11) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (uploaded_by) REFERENCES users(id) ON DELETE CASCADE
)";

if (!$conn->query($sql)) {
    die("Error membuat tabel documents: " . $conn->error);
}

// Buat tabel jemaat
$sql = "CREATE TABLE IF NOT EXISTS jemaat (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    nama_jemaat VARCHAR(255) NOT NULL,
    alamat_jemaat TEXT,
    kota VARCHAR(100),
    provinsi VARCHAR(100),
    kode_pos VARCHAR(10),
    nomor_telepon VARCHAR(20),
    email VARCHAR(100),
    nama_pendeta VARCHAR(255),
    jumlah_anggota INT(11) DEFAULT 0,
    deskripsi TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
)";

if (!$conn->query($sql)) {
    die("Error membuat tabel jemaat: " . $conn->error);
}

// Buat tabel peserta
$sql = "CREATE TABLE IF NOT EXISTS peserta (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    jemaat_id INT(11) NOT NULL,
    nama VARCHAR(255) NOT NULL,
    tanggal_lahir DATE NOT NULL,
    alamat TEXT,
    nomor_hp VARCHAR(20),
    jenis_kelamin ENUM('Laki-laki', 'Perempuan') NOT NULL,
    asal_jemaat VARCHAR(255),
    foto_peserta VARCHAR(255),
    status ENUM('Aktif', 'Tidak Aktif') DEFAULT 'Aktif',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (jemaat_id) REFERENCES jemaat(id) ON DELETE CASCADE
)";

if (!$conn->query($sql)) {
    die("Error membuat tabel peserta: " . $conn->error);
}



// Buat tabel activity_logs
$sql = "CREATE TABLE IF NOT EXISTS activity_logs (
    id INT(11) AUTO_INCREMENT PRIMARY KEY,
    user_id INT(11) NOT NULL,
    username VARCHAR(50) NOT NULL,
    full_name VARCHAR(100) NOT NULL,
    action ENUM('CREATE', 'UPDATE', 'DELETE', 'LOGIN', 'LOGOUT', 'UPLOAD', 'DOWNLOAD', 'IMPORT', 'EXPORT') NOT NULL,
    table_name VARCHAR(50),
    record_id INT(11),
    description TEXT,
    ip_address VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
)";

if (!$conn->query($sql)) {
    die("Error membuat tabel activity_logs: " . $conn->error);
}

// Insert default users jika belum ada
$check_admin = $conn->query("SELECT * FROM users WHERE username = 'admin'");
if ($check_admin->num_rows == 0) {
    $admin_password = password_hash('admin123', PASSWORD_DEFAULT);
    $sql = "INSERT INTO users (username, password, full_name, email, role) VALUES 
            ('admin', '$admin_password', 'Administrator', 'admin@example.com', 'administrator'),
            ('panitia', '$admin_password', 'Panitia', 'panitia@example.com', 'panitia'),
            ('peserta', '$admin_password', 'Peserta', 'peserta@example.com', 'peserta')";
    $conn->query($sql);
    

}

?>